package user_interface;
import db_context.MyExceptions;
import row_data_gateway.*;
import row_data_gateway.Package;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class MenuPackage extends Menu {
    @Override
    public void print() {
        System.out.println("***********************************");
        System.out.println("* 1. list items in package        *");
        System.out.println("* 2. create package               *");
        System.out.println("* 3. add item to package          *");
        System.out.println("* 4. add attempt to delivery      *");
        System.out.println("* 5. back to main menu            *");
        System.out.println("***********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   listItemsInPackage(); break;
                case "2":   createPackage(); break;
                case "3":   addItemToPackage(); break;
                case "4":   addDeliveryAttempt(); break;
                case "5":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }
        } catch(Exception e) {
            //throw new RuntimeException(e);
            if(e.getClass().toString().equals("class java.lang.NumberFormatException")) System.out.println("Wrong input");
            else if (e.getClass().toString().equals("class org.postgresql.util.PSQLException")) System.out.println("No such person");
            else System.out.println("something went wrong\nmessage: " + e.getMessage());
        }
    }

    private void listItemsInPackage() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter package id:");

        int package_id = Integer.parseInt(br.readLine());
        Package p = PackageFinder.getInstance().findById(package_id);

        System.out.println("..id..|....name....|....weight....|....price....|.uninsured ratio.|..package id..");
        for (Item item : ItemsFinder.getInstance().findByPackageId(package_id)) {
            item.print(item);
        }
    }

    private void createPackage() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Package p = new Package();

        System.out.println("Enter whether package has insurance:   (y,yes,Yes)");
        p.setInsurance(br.readLine());
        System.out.println("Enter sender id:");
        p.setSender_id(Integer.parseInt(br.readLine()));
        System.out.println("Enter recipient id:");
        p.setRecipient_id(Integer.parseInt(br.readLine()));

        br.readLine();
        p.insert();

        System.out.println("The package has been created");
        System.out.print("The package id is: " + p.getId());
    }

    private void addItemToPackage() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter item id");

        Item item = ItemsFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        if(item.getPackage_id() != null) throw new MyExceptions.LogicException("This item is in another package");

        System.out.println("Enter package id");
        Package p = PackageFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        if(!p.getStatus().equals("new")) throw  new MyExceptions.LogicException("Cannot add items to this package");
        item.setPackage_id(p.getId());
        item.update();
        System.out.println("The item with id: " + item.getId() + " has been added to package with id: " + item.getPackage_id());
    }

    private void addDeliveryAttempt() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter package id");

        Package p = PackageFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        p.setDelivery_attempts(p.getDelivery_attempts() + 1);
        p.update();
        System.out.println("attempt to delivery has been added to package with id: " + p.getId());
    }
}
